/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity.util.fabric;

import dev.architectury.registry.level.biome.BiomeModifications;
import dev.itsmeow.betteranimalsplus.imdlib.IMDLib;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.mixin.BiomeAccessor;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_3528;
import net.minecraft.class_5321;

public class BiomeTypesImpl {
    private static final class_3528<class_2385<class_1959>> REG = new class_3528(() -> IMDLib.getStaticServerInstance().method_30611().method_30530(class_2378.field_25114));

    public static void init() {
        BiomeTypes.HOT = new BiomeTypes.Type(biome -> {
            class_1959 biomeIn = BiomeTypesImpl.get((class_5321<class_1959>)biome);
            float temperature = biomeIn.method_8712();
            class_1959.class_1961 category = BiomeTypesImpl.c(biomeIn);
            return temperature > 0.85f || category == class_1959.class_1961.field_9368;
        }, biomeContext -> {
            float temperature = biomeContext.getProperties().getClimateProperties().getTemperature();
            class_1959.class_1961 category = biomeContext.getProperties().getCategory();
            return temperature > 0.85f || category == class_1959.class_1961.field_9368;
        });
        BiomeTypes.COLD = new BiomeTypes.Type(biome -> {
            class_1959 biomeIn = BiomeTypesImpl.get((class_5321<class_1959>)biome);
            float temperature = biomeIn.method_8712();
            class_1959.class_1961 category = BiomeTypesImpl.c(biomeIn);
            return temperature < 0.15f || category == class_1959.class_1961.field_9362;
        }, biomeContext -> {
            float temperature = biomeContext.getProperties().getClimateProperties().getTemperature();
            class_1959.class_1961 category = biomeContext.getProperties().getCategory();
            return temperature < 0.15f || category == class_1959.class_1961.field_9362;
        });
        BiomeTypes.SPARSE = BiomeTypesImpl.pathContains("sparse");
        BiomeTypes.DENSE = BiomeTypesImpl.pathContains("dense");
        BiomeTypes.WET = new BiomeTypes.Type(biome -> BiomeTypesImpl.get((class_5321<class_1959>)biome).method_8724(), biomeContext -> biomeContext.getProperties().getClimateProperties().getDownfall() > 0.85f);
        BiomeTypes.DRY = BiomeTypesImpl.catPath(class_1959.class_1961.field_9368, "arid");
        BiomeTypes.SAVANNA = BiomeTypesImpl.catPath(class_1959.class_1961.field_9356, "savanna");
        BiomeTypes.CONIFEROUS = BiomeTypesImpl.catPath(class_1959.class_1961.field_9361, "taiga");
        BiomeTypes.JUNGLE = BiomeTypesImpl.catPath(class_1959.class_1961.field_9358, "jungle");
        BiomeTypes.SPOOKY = BiomeTypesImpl.pathContains("spooky");
        BiomeTypes.DEAD = BiomeTypesImpl.pathContains("dead");
        BiomeTypes.LUSH = BiomeTypesImpl.pathContains("lush");
        BiomeTypes.MUSHROOM = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9365);
        BiomeTypes.MAGICAL = BiomeTypesImpl.pathContains("magic");
        BiomeTypes.RARE = new BiomeTypes.Type(biome -> biome.method_29177().method_12832().contains("rare") || biome.method_29177().method_12832().contains("modified"), biomeContext -> biomeContext.getKey().method_12832().contains("rare") || biomeContext.getKey().method_12832().contains("modified"));
        BiomeTypes.PLATEAU = BiomeTypesImpl.pathContains("plateau");
        BiomeTypes.MODIFIED = BiomeTypesImpl.pathContains("modified");
        BiomeTypes.OCEAN = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9367);
        BiomeTypes.RIVER = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9369);
        BiomeTypes.WATER = BiomeTypesImpl.catPredicate(c -> c == class_1959.class_1961.field_9367 || c == class_1959.class_1961.field_9369);
        BiomeTypes.MESA = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9354);
        BiomeTypes.FOREST = BiomeTypesImpl.catPathMulti(class_1959.class_1961.field_9370, "forest", "taiga");
        BiomeTypes.PLAINS = BiomeTypesImpl.catPath(class_1959.class_1961.field_9355, "plain");
        BiomeTypes.HILL = BiomeTypesImpl.catPath(class_1959.class_1961.field_9357, "hill");
        BiomeTypes.SWAMP = BiomeTypesImpl.catPath(class_1959.class_1961.field_9364, "swamp");
        BiomeTypes.SANDY = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9368);
        BiomeTypes.SNOWY = BiomeTypesImpl.catPath(class_1959.class_1961.field_9362, "snow");
        BiomeTypes.WASTELAND = BiomeTypesImpl.pathContains("waste");
        BiomeTypes.BEACH = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9363);
        BiomeTypes.VOID = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9371);
        BiomeTypes.UNDERGROUND = BiomeTypesImpl.catMatch(class_1959.class_1961.field_29217);
        BiomeTypes.PEAK = BiomeTypesImpl.catAndPath(class_1959.class_1961.field_34464, "peak");
        BiomeTypes.SLOPE = BiomeTypesImpl.catAndPath(class_1959.class_1961.field_34464, "slope");
        BiomeTypes.MOUNTAIN = new BiomeTypes.Type(b -> BiomeTypes.PEAK.hasType((class_5321<class_1959>)b) || BiomeTypes.SLOPE.hasType((class_5321<class_1959>)b) || BiomeTypesImpl.cat((class_5321<class_1959>)b) == class_1959.class_1961.field_34464, ctx -> BiomeTypes.PEAK.hasType((BiomeModifications.BiomeContext)ctx) || BiomeTypes.SLOPE.hasType((BiomeModifications.BiomeContext)ctx) || ctx.getProperties().getCategory() == class_1959.class_1961.field_34464);
        BiomeTypes.OVERWORLD = BiomeTypesImpl.catPredicate(c -> c != class_1959.class_1961.field_9366 && c != class_1959.class_1961.field_9360);
        BiomeTypes.NETHER = BiomeTypesImpl.catPath(class_1959.class_1961.field_9366, "nether");
        BiomeTypes.END = BiomeTypesImpl.catMatch(class_1959.class_1961.field_9360);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9423, BiomeTypes.OCEAN, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9451, BiomeTypes.PLAINS, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9424, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.SANDY, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35116, BiomeTypes.MOUNTAIN, BiomeTypes.HILL, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9409, BiomeTypes.FOREST, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9420, BiomeTypes.COLD, BiomeTypes.CONIFEROUS, BiomeTypes.FOREST, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9471, BiomeTypes.WET, BiomeTypes.SWAMP, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9438, BiomeTypes.RIVER, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9461, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.NETHER);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9411, BiomeTypes.COLD, BiomeTypes.DRY, BiomeTypes.END);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9435, BiomeTypes.COLD, BiomeTypes.OCEAN, BiomeTypes.SNOWY, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9463, BiomeTypes.COLD, BiomeTypes.RIVER, BiomeTypes.SNOWY, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35117, BiomeTypes.COLD, BiomeTypes.SNOWY, BiomeTypes.WASTELAND, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9462, BiomeTypes.MUSHROOM, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9434, BiomeTypes.BEACH, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9417, BiomeTypes.HOT, BiomeTypes.WET, BiomeTypes.DENSE, BiomeTypes.JUNGLE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35118, BiomeTypes.HOT, BiomeTypes.WET, BiomeTypes.JUNGLE, BiomeTypes.FOREST, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9446, BiomeTypes.OCEAN, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9419, BiomeTypes.BEACH, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9478, BiomeTypes.COLD, BiomeTypes.BEACH, BiomeTypes.SNOWY, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9412, BiomeTypes.FOREST, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9475, BiomeTypes.SPOOKY, BiomeTypes.DENSE, BiomeTypes.FOREST, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9454, BiomeTypes.COLD, BiomeTypes.CONIFEROUS, BiomeTypes.FOREST, BiomeTypes.SNOWY, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35119, BiomeTypes.COLD, BiomeTypes.CONIFEROUS, BiomeTypes.FOREST, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35120, BiomeTypes.MOUNTAIN, BiomeTypes.FOREST, BiomeTypes.SPARSE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9449, BiomeTypes.HOT, BiomeTypes.SAVANNA, BiomeTypes.PLAINS, BiomeTypes.SPARSE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9430, BiomeTypes.HOT, BiomeTypes.SAVANNA, BiomeTypes.PLAINS, BiomeTypes.SPARSE, BiomeTypes.RARE, BiomeTypes.OVERWORLD, BiomeTypes.PLATEAU);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9415, BiomeTypes.MESA, BiomeTypes.SANDY, BiomeTypes.DRY, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35110, BiomeTypes.MESA, BiomeTypes.SANDY, BiomeTypes.DRY, BiomeTypes.SPARSE, BiomeTypes.OVERWORLD, BiomeTypes.PLATEAU);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9457, BiomeTypes.END);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9447, BiomeTypes.END);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9442, BiomeTypes.END);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9465, BiomeTypes.END);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9408, BiomeTypes.OCEAN, BiomeTypes.HOT, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9441, BiomeTypes.OCEAN, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9467, BiomeTypes.OCEAN, BiomeTypes.COLD, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9439, BiomeTypes.OCEAN, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9470, BiomeTypes.OCEAN, BiomeTypes.COLD, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9418, BiomeTypes.OCEAN, BiomeTypes.COLD, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9473, BiomeTypes.VOID);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9455, BiomeTypes.PLAINS, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35111, BiomeTypes.MOUNTAIN, BiomeTypes.SPARSE, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9414, BiomeTypes.FOREST, BiomeTypes.HILL, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9453, BiomeTypes.COLD, BiomeTypes.SNOWY, BiomeTypes.HILL, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35112, BiomeTypes.FOREST, BiomeTypes.DENSE, BiomeTypes.HILL, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35113, BiomeTypes.DENSE, BiomeTypes.FOREST, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_35114, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.SPARSE, BiomeTypes.SAVANNA, BiomeTypes.MOUNTAIN, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9443, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.SPARSE, BiomeTypes.MOUNTAIN, BiomeTypes.RARE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_9440, BiomeTypes.HOT, BiomeTypes.WET, BiomeTypes.RARE, BiomeTypes.JUNGLE, BiomeTypes.OVERWORLD);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_22076, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.NETHER);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_22077, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.NETHER, BiomeTypes.FOREST);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_22075, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.NETHER, BiomeTypes.FOREST);
        BiomeTypesImpl.addTypes((class_5321<class_1959>)class_1972.field_23859, BiomeTypes.HOT, BiomeTypes.DRY, BiomeTypes.NETHER);
    }

    private static void addTypes(class_5321<class_1959> biome, BiomeTypes.Type ... types) {
        for (BiomeTypes.Type type : types) {
            type.addDefaults(biome);
        }
    }

    private static class_1959 get(class_5321<class_1959> biome) {
        return (class_1959)((class_2385)REG.method_15332()).method_10223(biome.method_29177());
    }

    private static class_1959.class_1961 c(class_1959 b) {
        return ((BiomeAccessor)b).getBiomeCategory();
    }

    private static class_1959.class_1961 cat(class_5321<class_1959> biome) {
        return BiomeTypesImpl.c((class_1959)((class_2385)REG.method_15332()).method_29107(biome));
    }

    private static BiomeTypes.Type catMatch(class_1959.class_1961 category) {
        return new BiomeTypes.Type(biome -> BiomeTypesImpl.cat((class_5321<class_1959>)biome) == category, biomeContext -> biomeContext.getProperties().getCategory() == category);
    }

    private static BiomeTypes.Type catPredicate(Predicate<class_1959.class_1961> predicate) {
        return new BiomeTypes.Type(biome -> predicate.test(BiomeTypesImpl.cat((class_5321<class_1959>)biome)), biomeContext -> predicate.test(biomeContext.getProperties().getCategory()));
    }

    private static BiomeTypes.Type pathContains(String content) {
        return new BiomeTypes.Type(biome -> biome.method_29177().method_12832().contains(content), biomeContext -> biomeContext.getKey().method_12832().contains(content));
    }

    private static BiomeTypes.Type catPath(class_1959.class_1961 category, String content) {
        return new BiomeTypes.Type(biome -> BiomeTypesImpl.cat((class_5321<class_1959>)biome) == category || biome.method_29177().method_12832().contains(content), biomeContext -> biomeContext.getProperties().getCategory() == category || biomeContext.getKey().method_12832().contains(content));
    }

    private static BiomeTypes.Type catAndPath(class_1959.class_1961 category, String content) {
        return new BiomeTypes.Type(biome -> BiomeTypesImpl.cat((class_5321<class_1959>)biome) == category && biome.method_29177().method_12832().contains(content), biomeContext -> biomeContext.getProperties().getCategory() == category || biomeContext.getKey().method_12832().contains(content));
    }

    private static BiomeTypes.Type catMultiPathMulti(Set<class_1959.class_1961> category, String ... content) {
        return new BiomeTypes.Type(biome -> category.contains(BiomeTypesImpl.cat((class_5321<class_1959>)biome)) || Arrays.stream(content).anyMatch(c -> biome.method_29177().method_12832().contains((CharSequence)c)), biomeContext -> category.contains(biomeContext.getProperties().getCategory()) || Arrays.stream(content).anyMatch(c -> biomeContext.getKey().method_12832().contains((CharSequence)c)));
    }

    private static BiomeTypes.Type catPathMulti(class_1959.class_1961 category, String ... content) {
        return new BiomeTypes.Type(biome -> BiomeTypesImpl.cat((class_5321<class_1959>)biome) == category || Arrays.stream(content).anyMatch(c -> biome.method_29177().method_12832().contains((CharSequence)c)), biomeContext -> biomeContext.getProperties().getCategory() == category || Arrays.stream(content).anyMatch(c -> biomeContext.getKey().method_12832().contains((CharSequence)c)));
    }

    private static BiomeTypes.Type reject() {
        return new BiomeTypes.Type(biome -> false, biomeContext -> false);
    }
}

